import base64
from django.core.files.base import ContentFile
from django.shortcuts import render, redirect, get_object_or_404
from .models import Drawing

def draw_board(request):
    if request.method == "POST":
        data_url = request.POST.get("image_data")
        if data_url:
            format, imgstr = data_url.split(';base64,')
            img_data = ContentFile(base64.b64decode(imgstr), name='drawing.png')
            Drawing.objects.create(image=img_data)
            return redirect('gallery')
    return render(request, 'board/draw.html')


def gallery(request):
    drawings = Drawing.objects.all().order_by('-created_at')
    return render(request, 'board/gallery.html', {'drawings': drawings})


def delete_drawing(request, pk):
    d = get_object_or_404(Drawing, pk=pk)
    d.delete()
    return redirect('gallery')
